/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.forge.curio;

import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.core.AELog;
import appeng.menu.locator.MenuLocator;
import de.mari_023.ae2wtlib.terminal.IUniversalWirelessTerminalItem;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;

public record CurioLocator(String identifier, int index) implements MenuLocator
{
    public CurioLocator(SlotContext slotContext) {
        this(slotContext.identifier(), slotContext.index());
    }

    @Nullable
    public <T> T locate(Player player, Class<T> hostInterface) {
        Item item;
        ItemStack it = this.locateItem(player);
        if (!it.m_41619_() && (item = it.m_41720_()) instanceof IUniversalWirelessTerminalItem) {
            IUniversalWirelessTerminalItem guiItem = (IUniversalWirelessTerminalItem)item;
            ItemMenuHost menuHost = guiItem.getMenuHost(player, this, it);
            if (hostInterface.isInstance(menuHost)) {
                return hostInterface.cast(menuHost);
            }
            if (menuHost != null) {
                AELog.warn((String)"Item in Curio slot with ID %s and index %s of %s did not create a compatible menu of type %s: %s", (Object[])new Object[]{this.identifier, this.index, player, hostInterface, menuHost});
            }
            return null;
        }
        AELog.warn((String)"Item in Curio slot with ID %s and index %s of %s is not an IMenuItem: %s", (Object[])new Object[]{this.identifier, this.index, player, it});
        return null;
    }

    public ItemStack locateItem(Player player) {
        List slotResults = CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, new String[]{this.identifier});
        for (SlotResult result : slotResults) {
            if (result.slotContext().index() != this.index) continue;
            return result.stack();
        }
        return ItemStack.f_41583_;
    }

    public void writeToPacket(FriendlyByteBuf buf) {
        buf.m_130070_(this.identifier);
        buf.writeInt(this.index);
    }

    public static CurioLocator readFromPacket(FriendlyByteBuf buf) {
        return new CurioLocator(buf.m_130277_(), buf.readInt());
    }
}

